'use strict';

/* --------------------------------------------------------------
 afterbuy.js 2016-07-07
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2016 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

$(function () {
    'use strict';

    var $table = $('.orders .table-main');

    $table.on('init.dt', function () {
        var _initSingleAction = function _initSingleAction($table) {
            $table.find('.btn-group.dropdown').each(function () {
                var orderId = $(this).parents('tr').data('id');
                var defaultRowAction = $table.data('defaultRowAction') || 'edit';

                jse.libs.button_dropdown.addAction($(this), {
                    text: jse.core.lang.translate('BUTTON_AFTERBUY_SEND', 'admin_buttons'),
                    href: '',
                    class: 'afterbuy-send',
                    data: { configurationValue: 'afterbuy-send' },
                    isDefault: defaultRowAction === 'afterbuy-send',
                    callback: function callback(event) {
                        event.preventDefault();

                        $.ajax({
                            url: jse.core.config.get('appUrl') + '/admin/admin.php?do=AfterbuyAjax/AfterbuySend&orderId=' + orderId,
                            error: function error() {
                                console.log('Afterbuy send error');
                            }
                        });
                    }
                });
            });
        };

        $table.on('draw.dt', function () {
            return _initSingleAction($table);
        });
        _initSingleAction($table);
    });
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
